/*
 * Decompiled with CFR 0.152.
 */
package ch.netmania.mp3copy;

import ch.netmania.mp3copy.utils.Message;
import ch.netmania.mp3copy.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CopyJob
extends Observable
implements Runnable {
    private int copiedFiles;
    private File currentWorkingDir;
    private File dest;
    private int folderNumber;
    private Map<Integer, File> map;
    private Random random;
    private Set<Integer> usedInt = new HashSet<Integer>();
    private Logger log = Logger.getLogger(CopyJob.class);
    private int maxFileNumber;
    private boolean runnable;
    private boolean cleanerFinished;
    private boolean indexerFinished;
    private double currentRandomStaus;
    private double currentCopyStatus;

    public CopyJob(Map<Integer, File> map, File dest, int maxFileNumber) {
        this.dest = dest;
        this.map = map;
        this.maxFileNumber = maxFileNumber;
        this.folderNumber = 1;
        this.runnable = true;
        this.cleanerFinished = false;
        this.indexerFinished = false;
    }

    public int copyAllFiles() throws IOException {
        int counter = 0;
        for (File sourceFile : this.map.values()) {
            if (sourceFile.length() > this.dest.getFreeSpace()) continue;
            this.copyFile(sourceFile);
            ++counter;
        }
        return counter;
    }

    private void copyFile(File sourceFile) throws IOException {
        Date start = new Date();
        this.currentWorkingDir = new File(this.dest, Utils.padLeft(this.folderNumber));
        this.currentWorkingDir.mkdirs();
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(new File(this.currentWorkingDir, sourceFile.getName())).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
        ++this.copiedFiles;
        if (this.copiedFiles > this.maxFileNumber - 1) {
            this.copiedFiles = 0;
            ++this.folderNumber;
        }
        this.log.debug("copied file " + sourceFile.getName() + " in " + Utils.calculateDuration(start));
    }

    public int copyRandomFiles() throws IOException {
        Date startRandom = new Date();
        int counter = 0;
        this.random = new Random();
        Vector<Integer> vector = new Vector<Integer>();
        this.log.info("start calculating random");
        while (vector.size() < this.map.size() && this.runnable) {
            int rnd = this.random.nextInt(this.map.size());
            if (this.usedInt.contains(rnd)) continue;
            vector.add(rnd);
            this.usedInt.add(rnd);
            int randomStatus = this.getRandomStatus(vector.size(), this.map.size());
            if (!((double)randomStatus > this.currentRandomStaus)) continue;
            this.setChanged();
            this.notifyObservers(new Message(20, randomStatus));
            this.currentRandomStaus = randomStatus;
        }
        this.log.info("end calculation random after " + Utils.calculateDuration(startRandom));
        this.setChanged();
        this.notifyObservers(new Message(21, Utils.calculateDuration(startRandom)));
        this.log.info("start copy");
        this.notifyObservers(new Message(22, 0));
        for (Integer i : vector) {
            if (!this.runnable) continue;
            File randomFile = this.map.get(i);
            if (randomFile.length() > this.dest.getFreeSpace()) break;
            this.copyFile(randomFile);
            int copyStatus = this.getRandomStatus(++counter, vector.size());
            if (!((double)copyStatus > this.currentCopyStatus) || !this.runnable) continue;
            this.setChanged();
            this.notifyObservers(new Message(22, copyStatus));
            this.currentCopyStatus = copyStatus;
        }
        if (this.runnable) {
            this.setChanged();
            this.notifyObservers(new Message(23, Utils.calculateDuration(startRandom)));
        }
        this.log.info("end copy after " + Utils.calculateDuration(startRandom));
        return counter;
    }

    private int getRandomStatus(double size, double total) {
        int status = (int)(size / total * 100.0);
        this.log.debug("copy status " + status);
        this.log.debug("total " + total);
        this.log.debug("current" + size);
        return status;
    }

    @Override
    public void run() {
        while (this.runnable) {
            if (this.indexerFinished && this.cleanerFinished) {
                try {
                    this.copyRandomFiles();
                    this.runnable = false;
                }
                catch (IOException e) {
                    this.log.error("cannot write files", e);
                }
                continue;
            }
            this.log.debug("Other Threads are still running");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.log.error(e);
            }
        }
    }

    public void setRunnable(boolean runnable) {
        this.runnable = runnable;
    }

    public void setIndexerFinished(boolean b) {
        this.indexerFinished = b;
    }

    public void setCleanerFinished(boolean b) {
        this.cleanerFinished = b;
    }

    public boolean isRunnable() {
        return this.runnable;
    }
}

