/*
 * Decompiled with CFR 0.152.
 */
package ch.netmania.mp3copy;

import ch.netmania.mp3copy.utils.FileHandler;
import ch.netmania.mp3copy.utils.Message;
import ch.netmania.mp3copy.utils.Utils;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class LibIndexer
extends Observable
implements Runnable {
    private int counter = 0;
    private Map<Integer, File> map;
    private Logger log = Logger.getLogger(LibIndexer.class);
    private File rootFolder;
    private String[] fileExtensions;
    private boolean runnable;
    private int lastState;
    private int sourceFileCount;

    public LibIndexer(File rootFolder, String fileExtensions) {
        this.map = new HashMap<Integer, File>();
        this.rootFolder = rootFolder;
        this.createFileExtensions(fileExtensions);
        this.runnable = true;
    }

    private void createFileExtensions(String fileExtensionList) {
        StringTokenizer tokenizer = new StringTokenizer(fileExtensionList, ";");
        this.fileExtensions = new String[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreElements()) {
            this.fileExtensions[count] = tokenizer.nextToken();
            ++count;
        }
    }

    private void testFile(File file) {
        int state = this.getStatus();
        if (this.lastState < state) {
            this.setChanged();
            this.notifyObservers(new Message(10, state));
            this.lastState = state;
        }
        if (this.runnable) {
            if (file.isFile() && this.matches(file)) {
                this.map.put(this.counter++, file);
            } else if (file.isDirectory() && file.listFiles().length > 0) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File sub = fileArray[n2];
                    this.testFile(sub);
                    ++n2;
                }
            } else {
                this.log.debug("folder or file " + file + " not indexed");
            }
        }
    }

    private int getStatus() {
        this.log.debug("counter " + this.counter + " sourceFilecount " + this.sourceFileCount);
        int status = (int)((double)this.counter / (double)this.sourceFileCount * 100.0);
        this.log.debug("indexer status " + status);
        return status;
    }

    private boolean matches(File file) {
        boolean match = false;
        String[] stringArray = this.fileExtensions;
        int n = this.fileExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileExtension = stringArray[n2];
            if (file.getName().endsWith("." + fileExtension)) {
                match = true;
            }
            ++n2;
        }
        return match;
    }

    @Override
    public void run() {
        this.log.info("start indexing source folder");
        this.log.debug("scanning for file count start");
        this.sourceFileCount = FileHandler.scanFolder(this.rootFolder, false).size();
        this.log.debug("scanning file count end found " + this.sourceFileCount + " files");
        Date start = new Date();
        this.testFile(this.rootFolder);
        this.setChanged();
        this.notifyObservers(new Message(11, Utils.calculateDuration(start)));
        this.log.info("end indexing source folder after " + Utils.calculateDuration(start));
    }

    public Map<Integer, File> getHashmapMap() {
        return this.map;
    }

    public void setRunnable(boolean b) {
        this.runnable = b;
    }

    public boolean isRunnable() {
        return this.runnable;
    }
}

