/*
 * Decompiled with CFR 0.152.
 */
package ch.netmania.mp3copy.utils;

import ch.netmania.mp3copy.gui.InputValidationException;
import java.io.File;
import java.util.Date;

public class Utils {
    public static String calculateDuration(Date start) {
        Date end = new Date();
        long duration = end.getTime() - start.getTime();
        if (duration < 1000L) {
            return String.valueOf(duration) + " ms";
        }
        if (duration < 60000L) {
            return String.valueOf((double)duration / 1000.0) + " sec";
        }
        if (duration == 60000L) {
            return "1 min";
        }
        return String.valueOf(duration / 60000L) + " min " + (double)(duration - duration / 60000L * 60000L) / 1000.0 + " sec";
    }

    public static String padLeft(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return String.valueOf(i);
    }

    public static int validateNumberInput(String text) throws InputValidationException {
        try {
            int number = Integer.parseInt(text);
            return number;
        }
        catch (NumberFormatException e) {
            throw new InputValidationException(String.valueOf(text) + " is not a valid integer", e);
        }
    }

    public static String checkIsValidFileList(String text) throws InputValidationException {
        if (text.matches("[[[A-Za-z0-9]{1,3}][;]?]*")) {
            return text;
        }
        throw new InputValidationException(String.valueOf(text) + " is not a valid file inclusion list");
    }

    public static File checkIsValidTargetDir(String targetDir) throws InputValidationException {
        File file = new File(targetDir);
        if (file.exists() && file.isDirectory() && file.canWrite()) {
            return new File(targetDir);
        }
        throw new InputValidationException(String.valueOf(targetDir) + " is not an accessible directory");
    }

    public static File checkIsValidSourceDir(String sourceDir) throws InputValidationException {
        File file = new File(sourceDir);
        if (file.exists() && file.isDirectory() && file.canRead()) {
            return new File(sourceDir);
        }
        throw new InputValidationException(String.valueOf(sourceDir) + " is not a valid source directory");
    }
}

