/*
 * Decompiled with CFR 0.152.
 */
package ch.netmania.mp3copy.gui;

import ch.netmania.mp3copy.CopyJob;
import ch.netmania.mp3copy.LibIndexer;
import ch.netmania.mp3copy.TargetCleaner;
import ch.netmania.mp3copy.gui.AboutDialog;
import ch.netmania.mp3copy.gui.AlertDialog;
import ch.netmania.mp3copy.gui.InputValidationException;
import ch.netmania.mp3copy.utils.Configuration;
import ch.netmania.mp3copy.utils.Message;
import ch.netmania.mp3copy.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MainGuiWindow
extends Composite
implements Observer {
    private Group sourceGroup;
    private Text sourceDir;
    private Label copyTimeLabel;
    private Label randomTimeLabel;
    private Label readSourceFolderTimeLabel;
    private ProgressBar cleanupProgressBar;
    private ProgressBar copyFilesProgressBar;
    private ProgressBar generateRandomProgressBar;
    private ProgressBar readSourceFolderProgressBar;
    private MenuItem fileSubMenuExit;
    private MenuItem fileSubMenuSaveSettingsOnExit;
    private Label folderSizeLabel2;
    private Text folderSizeField;
    private Label folderSizeLabel1;
    private Button exitButton;
    private Menu menu2;
    private MenuItem mainMenuAboutItem;
    private Menu menu1;
    private MenuItem mainMenuFileItem;
    private Menu mainWindowMenuBar;
    private Label cleanUpTimeLabel;
    private Label copyFilesToDestLabel;
    private Label deleteDestinationLabel;
    private Label createRandomLabel;
    private Label readSourceFolderLabel;
    private Button copyButton;
    private Label destFolderLabel;
    private Label currentTaskLabel;
    private Label fileInclusionListLabel;
    private Text fileInclusionListField;
    private Button useFreeSpace;
    private Button emptyDirectory;
    private Button destDirBrowseButton;
    private Button sourceDirBrowseButton;
    private Label sourceDirLabel;
    private Text destDir;
    private Group progressGroup;
    private Configuration config;
    private Logger log = Logger.getLogger(MainGuiWindow.class);
    final Shell shell;
    private MenuItem showAbout;
    private Label totalTime;
    private Label totalTimeLabel;
    private Button abortButton;
    private TargetCleaner cleaner;
    private LibIndexer indexer;
    private CopyJob copyJob;
    private Date startTime;

    public MainGuiWindow(Shell parent, int style) {
        super(parent, style);
        try {
            this.config = Configuration.getInstance();
        }
        catch (FileNotFoundException e) {
            this.handleGuiException(e);
        }
        catch (IOException e) {
            this.handleGuiException(e);
        }
        this.shell = parent;
        this.initGUI();
        this.setDefaultPropertiesValues();
    }

    @Override
    protected void checkSubclass() {
    }

    public Button getAbortButton() {
        return this.abortButton;
    }

    public ProgressBar getCleanupProgressBar() {
        return this.cleanupProgressBar;
    }

    public Label getCleanUpTimeLabel() {
        return this.cleanUpTimeLabel;
    }

    public Button getCopyButton() {
        return this.copyButton;
    }

    public ProgressBar getCopyFilesProgressBar() {
        return this.copyFilesProgressBar;
    }

    public Label getCopyFilesToDestLabel() {
        return this.copyFilesToDestLabel;
    }

    public Label getCreateRandomLabel() {
        return this.createRandomLabel;
    }

    public Text getDestDir() {
        return this.destDir;
    }

    public String getFileInclusionList() {
        return this.fileInclusionListField.getText();
    }

    public Text getFolderSizeField() {
        return this.folderSizeField;
    }

    public ProgressBar getGenerateRandomProgressBar() {
        return this.generateRandomProgressBar;
    }

    public Label getRandomTimeLabel() {
        return this.randomTimeLabel;
    }

    public ProgressBar getReadSourceFolderProgressBar() {
        return this.readSourceFolderProgressBar;
    }

    public Text getSourceDir() {
        return this.sourceDir;
    }

    private void handleGuiException(Exception e) {
        this.log.error("an exception occured " + e.getStackTrace());
        AlertDialog alertDialog = new AlertDialog(this.shell, 0);
        alertDialog.open(e.getMessage());
        this.abortOperation();
    }

    private void showAboutDialog() {
        this.log.debug("show about Dialog");
        AboutDialog ad = new AboutDialog(this.shell, 0);
        ad.open();
    }

    private void initGUI() {
        try {
            this.setLayout(new FormLayout());
            this.addDisposeListener(new DisposeListener(){

                @Override
                public void widgetDisposed(DisposeEvent evt) {
                    MainGuiWindow.this.saveSettingsAndExit();
                }
            });
            this.progressGroup = new Group(this, 0);
            FormLayout ProgressLayout = new FormLayout();
            this.progressGroup.setLayout(ProgressLayout);
            FormData ProgressLData = new FormData();
            ProgressLData.width = 607;
            ProgressLData.height = 210;
            ProgressLData.top = new FormAttachment(0, 1000, 180);
            ProgressLData.left = new FormAttachment(0, 1000, 12);
            ProgressLData.right = new FormAttachment(1000, 1000, -12);
            this.progressGroup.setLayoutData(ProgressLData);
            this.progressGroup.setText("Progress Info");
            this.totalTime = new Label(this.progressGroup, 0);
            FormData totalTimeLData = new FormData();
            totalTimeLData.width = 120;
            totalTimeLData.height = 13;
            totalTimeLData.left = new FormAttachment(0, 1000, 182);
            totalTimeLData.top = new FormAttachment(0, 1000, 125);
            this.totalTime.setLayoutData(totalTimeLData);
            this.totalTime.setText("00:00:00");
            this.totalTime.setVisible(false);
            this.totalTimeLabel = new Label(this.progressGroup, 0);
            FormData totalTimeLabelLData = new FormData();
            totalTimeLabelLData.width = 80;
            totalTimeLabelLData.height = 13;
            totalTimeLabelLData.left = new FormAttachment(0, 1000, 35);
            totalTimeLabelLData.top = new FormAttachment(0, 1000, 125);
            this.totalTimeLabel.setLayoutData(totalTimeLabelLData);
            this.totalTimeLabel.setText("Total Time");
            this.cleanUpTimeLabel = new Label(this.progressGroup, 0);
            FormData cleanUpTimeLabelLData = new FormData();
            cleanUpTimeLabelLData.width = 124;
            cleanUpTimeLabelLData.height = 17;
            cleanUpTimeLabelLData.left = new FormAttachment(0, 1000, 182);
            cleanUpTimeLabelLData.top = new FormAttachment(0, 1000, 41);
            this.cleanUpTimeLabel.setLayoutData(cleanUpTimeLabelLData);
            this.cleanUpTimeLabel.setText("00:00:00");
            this.cleanUpTimeLabel.setVisible(false);
            this.readSourceFolderTimeLabel = new Label(this.progressGroup, 0);
            FormData readSourceFolderTimeLabelLData = new FormData();
            readSourceFolderTimeLabelLData.width = 116;
            readSourceFolderTimeLabelLData.height = 17;
            readSourceFolderTimeLabelLData.left = new FormAttachment(0, 1000, 182);
            readSourceFolderTimeLabelLData.top = new FormAttachment(0, 1000, 62);
            this.readSourceFolderTimeLabel.setLayoutData(readSourceFolderTimeLabelLData);
            this.readSourceFolderTimeLabel.setText("00:00:00");
            this.readSourceFolderTimeLabel.setVisible(false);
            this.randomTimeLabel = new Label(this.progressGroup, 0);
            FormData randomTimeLabelLData = new FormData();
            randomTimeLabelLData.width = 120;
            randomTimeLabelLData.height = 17;
            randomTimeLabelLData.left = new FormAttachment(0, 1000, 182);
            randomTimeLabelLData.top = new FormAttachment(0, 1000, 83);
            this.randomTimeLabel.setLayoutData(randomTimeLabelLData);
            this.randomTimeLabel.setText("00:00:00");
            this.randomTimeLabel.setVisible(false);
            this.copyTimeLabel = new Label(this.progressGroup, 0);
            FormData copyTimeLabelLData = new FormData();
            copyTimeLabelLData.width = 126;
            copyTimeLabelLData.height = 17;
            copyTimeLabelLData.left = new FormAttachment(0, 1000, 182);
            copyTimeLabelLData.top = new FormAttachment(0, 1000, 104);
            this.copyTimeLabel.setLayoutData(copyTimeLabelLData);
            this.copyTimeLabel.setText("00:00:00");
            this.copyTimeLabel.setVisible(false);
            this.copyTimeLabel.setVisible(false);
            FormData cleanupProgressBarLData = new FormData();
            cleanupProgressBarLData.width = 170;
            cleanupProgressBarLData.height = 17;
            cleanupProgressBarLData.left = new FormAttachment(0, 1000, 182);
            cleanupProgressBarLData.top = new FormAttachment(0, 1000, 41);
            this.cleanupProgressBar = new ProgressBar(this.progressGroup, 0);
            this.cleanupProgressBar.setLayoutData(cleanupProgressBarLData);
            this.cleanupProgressBar.setVisible(false);
            FormData copyFilesProgressBarLData = new FormData();
            copyFilesProgressBarLData.width = 170;
            copyFilesProgressBarLData.height = 17;
            copyFilesProgressBarLData.left = new FormAttachment(0, 1000, 182);
            copyFilesProgressBarLData.top = new FormAttachment(0, 1000, 104);
            this.copyFilesProgressBar = new ProgressBar(this.progressGroup, 0);
            this.copyFilesProgressBar.setLayoutData(copyFilesProgressBarLData);
            this.copyFilesProgressBar.setVisible(false);
            FormData generateRandomProgressBarLData = new FormData();
            generateRandomProgressBarLData.width = 170;
            generateRandomProgressBarLData.height = 17;
            generateRandomProgressBarLData.left = new FormAttachment(0, 1000, 182);
            generateRandomProgressBarLData.top = new FormAttachment(0, 1000, 83);
            this.generateRandomProgressBar = new ProgressBar(this.progressGroup, 0);
            this.generateRandomProgressBar.setLayoutData(generateRandomProgressBarLData);
            this.generateRandomProgressBar.setVisible(false);
            FormData readSourceFolderProgressBarLData = new FormData();
            readSourceFolderProgressBarLData.width = 170;
            readSourceFolderProgressBarLData.height = 17;
            readSourceFolderProgressBarLData.left = new FormAttachment(0, 1000, 182);
            readSourceFolderProgressBarLData.top = new FormAttachment(0, 1000, 62);
            this.readSourceFolderProgressBar = new ProgressBar(this.progressGroup, 0);
            this.readSourceFolderProgressBar.setLayoutData(readSourceFolderProgressBarLData);
            this.readSourceFolderProgressBar.setVisible(false);
            this.currentTaskLabel = new Label(this.progressGroup, 0);
            FormData currentTaskLabelLData = new FormData();
            currentTaskLabelLData.width = 75;
            currentTaskLabelLData.height = 15;
            currentTaskLabelLData.left = new FormAttachment(0, 1000, 7);
            currentTaskLabelLData.top = new FormAttachment(0, 1000, 19);
            this.currentTaskLabel.setLayoutData(currentTaskLabelLData);
            this.currentTaskLabel.setText("Tasks");
            this.deleteDestinationLabel = new Label(this.progressGroup, 0);
            FormData deleteDestinationLabelLData = new FormData();
            deleteDestinationLabelLData.width = 132;
            deleteDestinationLabelLData.height = 15;
            deleteDestinationLabelLData.left = new FormAttachment(0, 1000, 35);
            deleteDestinationLabelLData.top = new FormAttachment(0, 1000, 41);
            this.deleteDestinationLabel.setLayoutData(deleteDestinationLabelLData);
            this.deleteDestinationLabel.setText("Delete Destination Folder");
            this.readSourceFolderLabel = new Label(this.progressGroup, 0);
            FormData readSourceFolderLabelLData = new FormData();
            readSourceFolderLabelLData.width = 102;
            readSourceFolderLabelLData.height = 14;
            readSourceFolderLabelLData.left = new FormAttachment(0, 1000, 35);
            readSourceFolderLabelLData.top = new FormAttachment(0, 1000, 62);
            this.readSourceFolderLabel.setLayoutData(readSourceFolderLabelLData);
            this.readSourceFolderLabel.setText("Read Source Folder");
            this.createRandomLabel = new Label(this.progressGroup, 0);
            FormData createRandomLabelLData = new FormData();
            createRandomLabelLData.width = 120;
            createRandomLabelLData.height = 16;
            createRandomLabelLData.left = new FormAttachment(0, 1000, 35);
            createRandomLabelLData.top = new FormAttachment(0, 1000, 83);
            this.createRandomLabel.setLayoutData(createRandomLabelLData);
            this.createRandomLabel.setText("Calculate Random Sort");
            this.copyFilesToDestLabel = new Label(this.progressGroup, 0);
            FormData copyFilesToDestLabelLData = new FormData();
            copyFilesToDestLabelLData.width = 138;
            copyFilesToDestLabelLData.height = 16;
            copyFilesToDestLabelLData.left = new FormAttachment(0, 1000, 35);
            copyFilesToDestLabelLData.top = new FormAttachment(0, 1000, 104);
            this.copyFilesToDestLabel.setLayoutData(copyFilesToDestLabelLData);
            this.copyFilesToDestLabel.setText("Copy Files To Destination");
            this.abortButton = new Button(this.progressGroup, 0x1000008);
            FormData abortButtonLData = new FormData();
            abortButtonLData.left = new FormAttachment(0, 1000, 12);
            abortButtonLData.top = new FormAttachment(0, 1000, 165);
            abortButtonLData.width = 77;
            abortButtonLData.height = 35;
            this.abortButton.setLayoutData(abortButtonLData);
            this.abortButton.setText("Cancel");
            this.abortButton.setVisible(false);
            this.abortButton.setVisible(false);
            this.abortButton.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent evt) {
                    MainGuiWindow.this.abortOperation();
                }
            });
            this.copyButton = new Button(this.progressGroup, 0x1000008);
            FormData copyButtonLData = new FormData();
            copyButtonLData.width = 78;
            copyButtonLData.height = 36;
            copyButtonLData.left = new FormAttachment(0, 1000, 12);
            copyButtonLData.top = new FormAttachment(0, 1000, 165);
            this.copyButton.setLayoutData(copyButtonLData);
            this.copyButton.setText("Copy Files");
            this.copyButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseDown(MouseEvent evt) {
                    MainGuiWindow.this.startCopyProcess();
                }
            });
            this.exitButton = new Button(this.progressGroup, 0x1000008);
            FormData exitButtonLData = new FormData();
            exitButtonLData.width = 84;
            exitButtonLData.height = 35;
            exitButtonLData.top = new FormAttachment(0, 1000, 165);
            exitButtonLData.right = new FormAttachment(1000, 1000, -13);
            this.exitButton.setLayoutData(exitButtonLData);
            this.exitButton.setText("Exit");
            this.exitButton.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent evt) {
                    MainGuiWindow.this.saveSettingsAndExit();
                }
            });
            this.sourceGroup = new Group(this, 0);
            FormLayout sourceGroupLayout = new FormLayout();
            this.sourceGroup.setLayout(sourceGroupLayout);
            FormData sourceGroupLData = new FormData();
            sourceGroupLData.width = 607;
            sourceGroupLData.height = 149;
            sourceGroupLData.top = new FormAttachment(0, 1000, 4);
            sourceGroupLData.left = new FormAttachment(0, 1000, 12);
            sourceGroupLData.right = new FormAttachment(1000, 1000, -12);
            this.sourceGroup.setLayoutData(sourceGroupLData);
            this.sourceGroup.setText("Select Folders");
            this.folderSizeLabel2 = new Label(this.sourceGroup, 0);
            FormData folderSizeLabel2LData = new FormData();
            folderSizeLabel2LData.width = 25;
            folderSizeLabel2LData.height = 19;
            folderSizeLabel2LData.top = new FormAttachment(0, 1000, 128);
            folderSizeLabel2LData.right = new FormAttachment(1000, 1000, -92);
            this.folderSizeLabel2.setLayoutData(folderSizeLabel2LData);
            this.folderSizeLabel2.setText("Files");
            FormData folderSizeFieldLData = new FormData();
            folderSizeFieldLData.width = 19;
            folderSizeFieldLData.height = 15;
            folderSizeFieldLData.top = new FormAttachment(0, 1000, 128);
            folderSizeFieldLData.right = new FormAttachment(1000, 1000, -117);
            this.folderSizeField = new Text(this.sourceGroup, 0);
            this.folderSizeField.setLayoutData(folderSizeFieldLData);
            this.folderSizeLabel1 = new Label(this.sourceGroup, 0);
            FormData folderSizeLabel1LData = new FormData();
            folderSizeLabel1LData.width = 139;
            folderSizeLabel1LData.height = 15;
            folderSizeLabel1LData.top = new FormAttachment(0, 1000, 128);
            folderSizeLabel1LData.right = new FormAttachment(1000, 1000, -142);
            this.folderSizeLabel1.setLayoutData(folderSizeLabel1LData);
            this.folderSizeLabel1.setText("Create A New Folder Every");
            this.fileInclusionListLabel = new Label(this.sourceGroup, 0);
            FormData fileInclusionListLabelLData = new FormData();
            fileInclusionListLabelLData.width = 158;
            fileInclusionListLabelLData.height = 15;
            fileInclusionListLabelLData.left = new FormAttachment(0, 1000, 9);
            fileInclusionListLabelLData.top = new FormAttachment(0, 1000, 84);
            this.fileInclusionListLabel.setLayoutData(fileInclusionListLabelLData);
            this.fileInclusionListLabel.setText("Included Files (separate by ';')");
            this.fileInclusionListField = new Text(this.sourceGroup, 0);
            FormData fileExclusionListFieldLData = new FormData(185, 15);
            fileExclusionListFieldLData.width = 185;
            fileExclusionListFieldLData.height = 15;
            fileExclusionListFieldLData.left = new FormAttachment(0, 1000, 9);
            fileExclusionListFieldLData.top = new FormAttachment(0, 1000, 103);
            this.fileInclusionListField.setLayoutData(fileExclusionListFieldLData);
            this.fileInclusionListField.setSize(185, 15);
            this.fileInclusionListField.setOrientation(256);
            this.useFreeSpace = new Button(this.sourceGroup, 16400);
            FormData useFreeSpaceLData = new FormData();
            useFreeSpaceLData.width = 127;
            useFreeSpaceLData.height = 16;
            useFreeSpaceLData.top = new FormAttachment(0, 1000, 106);
            useFreeSpaceLData.right = new FormAttachment(1000, 1000, -154);
            this.useFreeSpace.setLayoutData(useFreeSpaceLData);
            this.useFreeSpace.setText("Use Only Free Space");
            this.useFreeSpace.setSelection(!this.config.getEmptyDir());
            this.emptyDirectory = new Button(this.sourceGroup, 16400);
            FormData emptyDirectoryLData = new FormData();
            emptyDirectoryLData.width = 221;
            emptyDirectoryLData.height = 16;
            emptyDirectoryLData.top = new FormAttachment(0, 1000, 84);
            emptyDirectoryLData.right = new FormAttachment(1000, 1000, -60);
            this.emptyDirectory.setLayoutData(emptyDirectoryLData);
            this.emptyDirectory.setText("Delete All Files From Destination");
            this.emptyDirectory.setSelection(this.config.getEmptyDir());
            this.destDirBrowseButton = new Button(this.sourceGroup, 0x1000008);
            FormData destDirBrowseButtonLData = new FormData();
            destDirBrowseButtonLData.width = 68;
            destDirBrowseButtonLData.height = 19;
            destDirBrowseButtonLData.top = new FormAttachment(0, 1000, 53);
            destDirBrowseButtonLData.right = new FormAttachment(1000, 1000, -213);
            this.destDirBrowseButton.setLayoutData(destDirBrowseButtonLData);
            this.destDirBrowseButton.setText("Browse...");
            this.destDirBrowseButton.setEnabled(false);
            this.sourceDirBrowseButton = new Button(this.sourceGroup, 0x1000008);
            FormData sourceDirBrowseButtonLData = new FormData();
            sourceDirBrowseButtonLData.width = 68;
            sourceDirBrowseButtonLData.height = 19;
            sourceDirBrowseButtonLData.left = new FormAttachment(0, 1000, 9);
            sourceDirBrowseButtonLData.top = new FormAttachment(0, 1000, 53);
            this.sourceDirBrowseButton.setLayoutData(sourceDirBrowseButtonLData);
            this.sourceDirBrowseButton.setText("Browse...");
            this.sourceDirBrowseButton.setEnabled(false);
            this.destFolderLabel = new Label(this.sourceGroup, 0);
            FormData destFolderLabelLData = new FormData();
            destFolderLabelLData.width = 100;
            destFolderLabelLData.height = 13;
            destFolderLabelLData.top = new FormAttachment(0, 1000, 9);
            destFolderLabelLData.right = new FormAttachment(1000, 1000, -181);
            this.destFolderLabel.setLayoutData(destFolderLabelLData);
            this.destFolderLabel.setText("Destination Folder");
            this.sourceDirLabel = new Label(this.sourceGroup, 0);
            FormData sourceDirLabelLData = new FormData();
            sourceDirLabelLData.width = 78;
            sourceDirLabelLData.height = 13;
            sourceDirLabelLData.top = new FormAttachment(0, 1000, 9);
            sourceDirLabelLData.left = new FormAttachment(0, 1000, 9);
            this.sourceDirLabel.setLayoutData(sourceDirLabelLData);
            this.sourceDirLabel.setText("Source Folder");
            this.sourceDir = new Text(this.sourceGroup, 0);
            FormData sourceDirLData = new FormData(266, 15);
            sourceDirLData.width = 266;
            sourceDirLData.height = 15;
            sourceDirLData.left = new FormAttachment(0, 1000, 9);
            sourceDirLData.top = new FormAttachment(0, 1000, 28);
            this.sourceDir.setLayoutData(sourceDirLData);
            this.sourceDir.setOrientation(256);
            this.sourceDir.setSize(266, 15);
            this.destDir = new Text(this.sourceGroup, 0);
            FormData destDirLData = new FormData(266, 15);
            destDirLData.width = 266;
            destDirLData.height = 15;
            destDirLData.top = new FormAttachment(0, 1000, 28);
            destDirLData.right = new FormAttachment(1000, 1000, -9);
            this.destDir.setLayoutData(destDirLData);
            this.destDir.setOrientation(256);
            this.destDir.setSize(266, 15);
            this.layout();
            this.pack();
            this.mainWindowMenuBar = new Menu(this.getShell(), 2);
            this.getShell().setMenuBar(this.mainWindowMenuBar);
            this.mainMenuFileItem = new MenuItem(this.mainWindowMenuBar, 64);
            this.mainMenuFileItem.setText("File");
            this.menu1 = new Menu(this.mainMenuFileItem);
            this.mainMenuFileItem.setMenu(this.menu1);
            this.fileSubMenuSaveSettingsOnExit = new MenuItem(this.menu1, 32);
            this.fileSubMenuSaveSettingsOnExit.setText("Save Settings On Exit");
            this.fileSubMenuSaveSettingsOnExit.setSelection(this.config.getSaveOnExit());
            new MenuItem(this.menu1, 2);
            this.fileSubMenuExit = new MenuItem(this.menu1, 8);
            this.fileSubMenuExit.setText("Exit");
            this.fileSubMenuExit.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent evt) {
                    MainGuiWindow.this.saveSettingsAndExit();
                }
            });
            this.mainMenuAboutItem = new MenuItem(this.mainWindowMenuBar, 64);
            this.mainMenuAboutItem.setText("?");
            this.menu2 = new Menu(this.mainMenuAboutItem);
            this.mainMenuAboutItem.setMenu(this.menu2);
            this.showAbout = new MenuItem(this.menu2, 8);
            this.showAbout.setText("about");
            this.showAbout.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent evt) {
                    MainGuiWindow.this.showAboutDialog();
                }
            });
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isCleanDest() {
        return this.emptyDirectory.getSelection();
    }

    private void savePropertiesFile() {
        try {
            this.config.savePropertiesFile();
        }
        catch (FileNotFoundException e) {
            this.handleGuiException(e);
        }
        catch (IOException e) {
            this.handleGuiException(e);
        }
    }

    private void saveSettingsAndExit() {
        if (this.fileSubMenuSaveSettingsOnExit.getSelection()) {
            this.updateProperties();
        }
        this.config.setSaveSettings(this.fileSubMenuSaveSettingsOnExit.getSelection());
        this.savePropertiesFile();
        this.log.debug("exiting application");
        System.exit(0);
    }

    private void setDefaultPropertiesValues() {
        this.sourceDir.setText(this.config.getSource().toString());
        this.destDir.setText(this.config.getDestination().toString());
        this.fileInclusionListField.setText(this.config.getFileExtension());
        this.folderSizeField.setText(String.valueOf(this.config.getMaxFileNumber()));
    }

    private void abortOperation() {
        this.log.debug("cancel button pressed");
        if (this.cleaner != null) {
            this.cleaner.setRunnable(false);
        }
        if (this.indexer != null) {
            this.indexer.setRunnable(false);
        }
        if (this.copyJob != null) {
            this.copyJob.setRunnable(false);
        }
        this.abortButton.setVisible(false);
        this.copyButton.setVisible(true);
        this.cleanProgress();
    }

    private void cleanProgress() {
        this.cleanUpTimeLabel.setVisible(false);
        this.cleanupProgressBar.setVisible(false);
        this.readSourceFolderTimeLabel.setVisible(false);
        this.readSourceFolderProgressBar.setVisible(false);
        this.randomTimeLabel.setVisible(false);
        this.generateRandomProgressBar.setVisible(false);
        this.copyFilesProgressBar.setVisible(false);
        this.copyTimeLabel.setVisible(false);
        this.totalTime.setVisible(false);
    }

    private void startCopyProcess() {
        this.startTime = new Date();
        this.cleanProgress();
        File sourceDirFile = null;
        File targetDirFile = null;
        int folderSize = 0;
        String fileList = null;
        try {
            sourceDirFile = Utils.checkIsValidSourceDir(this.sourceDir.getText());
            targetDirFile = Utils.checkIsValidTargetDir(this.destDir.getText());
            folderSize = Utils.validateNumberInput(this.folderSizeField.getText());
            fileList = Utils.checkIsValidFileList(this.fileInclusionListField.getText());
        }
        catch (InputValidationException e) {
            this.handleGuiException(e);
        }
        if (sourceDirFile != null && targetDirFile != null && fileList != null && folderSize != 0) {
            this.copyButton.setVisible(false);
            this.abortButton.setVisible(true);
            this.indexer = new LibIndexer(sourceDirFile, fileList);
            this.indexer.addObserver(this);
            Thread indexerThread = new Thread(this.indexer);
            indexerThread.start();
            this.readSourceFolderProgressBar.setVisible(true);
            this.copyJob = new CopyJob(this.indexer.getHashmapMap(), targetDirFile, folderSize);
            this.copyJob.addObserver(this);
            Thread copyThread = new Thread(this.copyJob);
            copyThread.start();
            if (this.emptyDirectory.getSelection()) {
                this.cleaner = new TargetCleaner(targetDirFile);
                this.cleaner.addObserver(this);
                Thread cleanerThread = new Thread(this.cleaner);
                cleanerThread.start();
                this.cleanupProgressBar.setVisible(true);
            } else {
                this.copyJob.setCleanerFinished(true);
            }
        }
    }

    private void updateProperties() {
        this.config.setDestination(this.destDir.getText());
        this.config.setSource(this.sourceDir.getText());
        this.config.setMaxFileNumber(this.folderSizeField.getText());
        this.config.setFileExtensions(this.fileInclusionListField.getText());
        this.config.setEmptyDir(this.emptyDirectory.getSelection());
        this.savePropertiesFile();
    }

    @Override
    public void update(Observable obs, Object mess) {
        Message message = (Message)mess;
        this.log.debug("got update from " + obs.getClass() + " of type " + message.getMessageType() + " with message " + message.getIntMessage() + " " + message.getStringMessage());
        if (message.getMessageType() == 0) {
            this.asyncUpdateCleanupProgressBar(message.getIntMessage());
        } else if (message.getMessageType() == 1) {
            this.asyncSetCleanerEnd(message.getStringMessage());
            this.copyJob.setCleanerFinished(true);
        } else if (message.getMessageType() == 10) {
            this.asyncUpdateIndexerProgressBar(message.getIntMessage());
        } else if (message.getMessageType() == 11) {
            this.asyncSetIndexerEnd(message.getStringMessage());
            this.copyJob.setIndexerFinished(true);
        } else if (message.getMessageType() == 20) {
            this.asyncUpdateRandomProgressBar(message.getIntMessage());
        } else if (message.getMessageType() == 21) {
            this.asyncSetRandomEnd(message.getStringMessage());
        } else if (message.getMessageType() == 22) {
            this.asyncUpdateCopyProgressBar(message.getIntMessage());
        } else if (message.getMessageType() == 23) {
            this.asyncSetCopyEnd(message.getStringMessage());
        }
    }

    private void asyncUpdateCleanupProgressBar(final int value) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MainGuiWindow.this.cleanupProgressBar.setSelection(value);
            }
        });
    }

    private void asyncSetCleanerEnd(final String message) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MainGuiWindow.this.cleanupProgressBar.setVisible(false);
                MainGuiWindow.this.cleanUpTimeLabel.setText(message);
                MainGuiWindow.this.cleanUpTimeLabel.setVisible(true);
            }
        });
    }

    private void asyncUpdateIndexerProgressBar(final int value) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MainGuiWindow.this.readSourceFolderProgressBar.setSelection(value);
            }
        });
    }

    private void asyncSetIndexerEnd(final String message) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MainGuiWindow.this.readSourceFolderProgressBar.setVisible(false);
                MainGuiWindow.this.readSourceFolderTimeLabel.setText(message);
                MainGuiWindow.this.readSourceFolderTimeLabel.setVisible(true);
            }
        });
    }

    private void asyncUpdateRandomProgressBar(final int value) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MainGuiWindow.this.generateRandomProgressBar.setVisible(true);
                MainGuiWindow.this.generateRandomProgressBar.setSelection(value);
            }
        });
    }

    private void asyncSetRandomEnd(final String message) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MainGuiWindow.this.generateRandomProgressBar.setVisible(false);
                MainGuiWindow.this.randomTimeLabel.setText(message);
                MainGuiWindow.this.randomTimeLabel.setVisible(true);
            }
        });
    }

    private void asyncUpdateCopyProgressBar(final int value) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MainGuiWindow.this.copyFilesProgressBar.setVisible(true);
                MainGuiWindow.this.copyFilesProgressBar.setSelection(value);
            }
        });
    }

    private void asyncSetCopyEnd(final String message) {
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MainGuiWindow.this.copyFilesProgressBar.setVisible(false);
                MainGuiWindow.this.copyTimeLabel.setText(message);
                MainGuiWindow.this.copyTimeLabel.setVisible(true);
                MainGuiWindow.this.abortButton.setVisible(false);
                MainGuiWindow.this.copyButton.setVisible(true);
                MainGuiWindow.this.totalTime.setVisible(true);
                MainGuiWindow.this.totalTime.setText(Utils.calculateDuration(MainGuiWindow.this.startTime));
            }
        });
    }
}

