/*
 * Decompiled with CFR 0.152.
 */
package ch.netmania.mp3copy.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class Configuration {
    private static Configuration config;
    public static final String PROPERTIES_NAME = "mp3copy.properties";
    public static final String PROPERTY_NAME_DESTINATION_FOLDER = "destination_folder";
    public static final String PROPERTY_NAME_FILE_EXTENSION = "file_extension";
    public static final String PROPERTY_NAME_MAX_FILES_PER_DIRECTORY = "max_file_per_folder";
    public static final String PROPERTY_NAME_SOURCE_FOLDER = "source_folder";
    public static final String PROPERTY_NAME_SAVE_ON_EXIT = "save_on_exit";
    public static final String PROPERTY_NAME_EMPTY_DIR = "empty_dir_before_copy";
    private static Properties props;

    public static synchronized Configuration getInstance() throws FileNotFoundException, IOException {
        if (config == null) {
            config = new Configuration();
            props = config.loadProperties();
        }
        return config;
    }

    private Configuration() {
    }

    public String getDestination() {
        return props.getProperty(PROPERTY_NAME_DESTINATION_FOLDER);
    }

    public String getFileExtension() {
        return props.getProperty(PROPERTY_NAME_FILE_EXTENSION);
    }

    public int getMaxFileNumber() {
        return Integer.parseInt(props.getProperty(PROPERTY_NAME_MAX_FILES_PER_DIRECTORY));
    }

    public String getSource() {
        return props.getProperty(PROPERTY_NAME_SOURCE_FOLDER);
    }

    public Boolean getSaveOnExit() {
        return Boolean.valueOf(props.getProperty(PROPERTY_NAME_SAVE_ON_EXIT));
    }

    private Properties loadProperties() throws FileNotFoundException, IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(PROPERTIES_NAME);
        }
        catch (FileNotFoundException e1) {
            this.createDefaultProperitesFile();
            is = new FileInputStream(PROPERTIES_NAME);
        }
        Properties props = new Properties();
        props.load(is);
        return props;
    }

    private void createDefaultProperitesFile() throws FileNotFoundException, IOException {
        props = new Properties();
        props.setProperty(PROPERTY_NAME_DESTINATION_FOLDER, "c:\\");
        props.setProperty(PROPERTY_NAME_FILE_EXTENSION, "mp3");
        props.setProperty(PROPERTY_NAME_MAX_FILES_PER_DIRECTORY, "100");
        props.setProperty(PROPERTY_NAME_SAVE_ON_EXIT, "true");
        props.setProperty(PROPERTY_NAME_SOURCE_FOLDER, "c:\\music\\");
        props.setProperty(PROPERTY_NAME_EMPTY_DIR, "true");
        this.savePropertiesFile();
    }

    public void setDestination(String text) {
        props.setProperty(PROPERTY_NAME_DESTINATION_FOLDER, text);
    }

    public void savePropertiesFile() throws FileNotFoundException, IOException {
        props.store(new FileOutputStream(PROPERTIES_NAME), null);
    }

    public void setSource(String text) {
        props.setProperty(PROPERTY_NAME_SOURCE_FOLDER, text);
    }

    public void setMaxFileNumber(String text) {
        props.setProperty(PROPERTY_NAME_MAX_FILES_PER_DIRECTORY, text);
    }

    public void setFileExtensions(String text) {
        props.setProperty(PROPERTY_NAME_FILE_EXTENSION, text);
    }

    public void setSaveSettings(Boolean selection) {
        props.setProperty(PROPERTY_NAME_SAVE_ON_EXIT, selection.toString());
    }

    public boolean getEmptyDir() {
        return Boolean.valueOf(props.getProperty(PROPERTY_NAME_EMPTY_DIR));
    }

    public void setEmptyDir(Boolean selection) {
        props.setProperty(PROPERTY_NAME_EMPTY_DIR, selection.toString());
    }
}

