/*
 * Decompiled with CFR 0.152.
 */
package ch.netmania.mp3copy;

import ch.netmania.mp3copy.utils.FileHandler;
import ch.netmania.mp3copy.utils.Message;
import ch.netmania.mp3copy.utils.Utils;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import org.apache.log4j.Logger;

public class TargetCleaner
extends Observable
implements Runnable {
    private List<File> files;
    private boolean runnable = true;
    private double fileCountAtStart;
    private double currentFile;
    private Logger log = Logger.getLogger(TargetCleaner.class);
    private int currentStatus;
    private File dest;

    public TargetCleaner(File dest) {
        this.dest = dest;
    }

    @Override
    public void run() {
        this.files = FileHandler.scanFolder(this.dest, true);
        this.fileCountAtStart = this.files.size();
        this.log.debug("the directory contains " + this.fileCountAtStart + " files or folders");
        Date start = new Date();
        this.log.debug("start deleting files " + this.files.size() + " files to delete");
        for (File file : this.files) {
            if (!this.runnable) continue;
            file.delete();
            this.currentFile = this.files.indexOf(file);
            int status = this.getStatus();
            if (this.currentStatus >= status) continue;
            this.setChanged();
            this.notifyObservers(new Message(0, status));
            this.currentStatus = status;
        }
        this.log.debug("delete finished");
        if (this.runnable) {
            this.setChanged();
            this.notifyObservers(new Message(1, Utils.calculateDuration(start)));
        }
        this.runnable = false;
    }

    public void setRunnable(boolean runnable) {
        this.runnable = runnable;
    }

    private int getStatus() {
        this.log.debug("calculating status current file " + this.currentFile + " total files " + this.fileCountAtStart);
        return (int)(this.currentFile / this.fileCountAtStart * 100.0);
    }
}

